---
Note type: Zettel
tags:
  - "#Zettel"
Related areas:
  - "[[Research]]"
Related projects:
  - "[[Paper Z]]"
Related tasks: 
Related MoCs:
  - "[[Methods MoC]]"
Related references:
  - "[[Mees-Buss et al. 2020]]"
  - "[[Locke, Golden-Biddle & Feldman 2008]]"
  - "[[Klag & Langley 2013]]"
  - "[[Kornberger & Mantere 2020]]"
  - "[[Gadamer 1989]]"
  - "[[Van Maanen 1979]]"
Related zettels:
  - "[[abductive analysis]]"
  - "[[coding inductive to abductive]]"
Related meeting notes: 
Related resources: 
Related people:
  - "[[Alfred Schütz]]"
  - "[[John Van Maanen]]"
aliases:
  - hermeneutic orientation toward interpretation
  - hermeneutic interpretation
  - hermeneutic interpretive method
Creation date: 2024-05-27
Last modified: 2024-05-27
Created: 2023-08-15 17:51
---

## Fleeting notes

## General notes

### Conceptual roots

#### Roots for [[hermeneutic interpretivism]]

[[hermeneutics]] has a “rich and varied history” in philosophy, comprising “multiple strands that range from the more critical to the realist (for a review, see Prasad, 2002; Thatchenkery, 2001; Tomkins & Eatough, 2018)” ([[Mees-Buss et al. 2020]], p. 414)
- [[Alfred Schütz]] (1954, 1960, 1964) - “origin of the concepts of first and second order.” ([[Mees-Buss et al. 2020]], p. 414)
	- Schütz, A. (1954). Concept and theory formation in the social sciences. The Journal of Philosophy, 51(9), 257–273.
	- Schütz, A. (1960). The social world and the theory of social action. Social Research, 27(4), 203–221.
- [[John Van Maanen|Van Maanen]]
	- Van Maanen, J. (1979). The fact of fiction in organizational ethnography. Administrative Science Quarterly, 24 (4), 539–550.
	- Van Maanen, J. (2011). Tales of the field: On writing ethnography (2nd ed.). University of Chicago Press.
	- Van Maanen, J., Sørensen, J. B., & Mitchell, T. R. (2007). The interplay between theory and method. Academy of Management Review, 32(4), 1145–1154.
- [[Silverman]]
	- Silverman, D. (1989). Six rules of qualitative research: A post-romantic argument. Symbolic Interaction, 12(2), 215–230.
	- Silverman, D. (2013). Doing qualitative research: A practical handbook (4th ed.). SAGE.
	- Silverman, D. (2017). How was it for you? The interview society and the irresistible rise of the (poorly analyzed) interview. Qualitative Research, 17(2), 144–158.
	- Silverman, D. (2020). Interpreting qualitative data (6th ed.). SAGE

#### Methodological work coherent with [[hermeneutic interpretivism]]

- [[Locke, Golden-Biddle & Feldman 2008]] - “Locke, K., Golden-Biddle, K., & Feldman, M. S. (2008). Making doubt generative: Rethinking the role of doubt in the research process. Organization Science, 19(6), 907–918.”
- [[Klag & Langley 2013]] - “Klag, M., & Langley, A. (2013). Approaching the conceptual leap in qualitative research. International Journal of Management Reviews, 15(2), 149–166.”
- [[Kornberger & Mantere 2020]] - “Kornberger, M., & Mantere, S. (2020). Thought experiments and philosophy in organizational research. Organization Theory, 1(3). https://doi.org/10.1177/2631787720942524”

#### Empirical exemplars

 - [[Gadamer 1989]]
 - [[Van Maanen 1979]]

### Definitions

[[hermeneutic interpretivism]] recognizes that “researchers are engaging in interpreting the interpretations of those they study” ([[Mees-Buss et al. 2020]], p. 415)
- “invites a much more critical attitude toward the interpreted nature of data, the role of the researcher as an interpreter, and the resultant knowledge claims.” ([[Mees-Buss et al. 2020]], p. 406) - [[reflexive scholarship]]
- “For researchers who adopt this hermeneutic orientation, rigor means challenging their—as well as their participants’—understanding of what is really going on or being said in the field setting” ([[Mees-Buss et al. 2020]], p. 406)
- “Revelatory theoretical insight requires interpretive rigor that relies on a process of discovery—of following redirections, clues, and new avenues of inquiry—to arrive at a deeper understanding of the social phenomena being studied.” ([[Mees-Buss et al. 2020]], p. 406)

### Useful ideas and quotations

“a return to a [[hermeneutics|hermeneutic]] orientation opens the way to more plausible and insightful theories based on **[[interpretivism|interpretive]]** rather than **procedural rigor**” ([[Mees-Buss et al. 2020]], p. 405)

![[Mees-Buss et al. 2020#The hermeneutic interpretivism hermeneutic orientation toward interpretation]]

![[Mees-Buss et al. 2020#John Van Maanen Van Maanen ’s hermeneutic interpretivism]]

![[Mees-Buss et al. 2020#Guiding heuristics for hermeneutic interpretivism]]
